/*
 * Practica 1.
 *
 * Practicas Metodologia de la Programacion.
 * Curso 2008 - 2009
 *
 * Vicente Lujan Mansilla
 * Lorena Margareto Bisquert
 */

#include <stdlib.h>
#include <iostream>
#include <assert.h>

#include "Complejo.h"
using namespace std;


/**
 * Genera un numero complejo a partir de los datos introducidos por el usuario.
 * 
 * @pre Introduccion de modulo y argumento validos.
 * @post Numero complejo en forma polar.   
 * @return Objeto "Complejo".
 */
Complejo introducirComplejo()
{
	Complejo numeroComplejo;
	float modulo, argumento;

	cout << "Introduce el modulo del complejo: ";
	cin >> modulo;
	cout << "Introduce el argumento del complejo: ";	
	cin >> argumento;
	cout << endl;
	numeroComplejo.set(modulo, argumento);
	
	return numeroComplejo;	
}

/**
 * Comprueba la igualdad entre dos numeros complejos.
 * 
 * @pre Dos numeros complejos validos.     
 * @return void.
 */
void comprobarIgualdad(Complejo operandoA, Complejo operandoB)
{	
	
    	cout << "-----------------------------------\n";
	cout << "-     COMPROBACION DE IGUALDAD    -\n";
	cout << "-----------------------------------\n\n";		
	
	if (operandoA == operandoB)
	{
		operandoA.print();
		cout << " = ";
		operandoB.print();
		cout << endl;
	}
	else 
	{
		operandoA.print();
		cout << " != ";
		operandoB.print();
		cout << endl;
	}
	
	/*Para la ejecucion del programa hasta que el usuario pulsa una tecla.*/
	getchar();
	getchar();
	
}

/**
 * Suma dos numeros complejos y muestra el resultado por pantalla.
 * 
 * @pre Dos numeros complejos validos.
 * @post Numero complejo valido.     
 * @return void.
 */
void comprobarSuma(Complejo operandoA, Complejo operandoB)
{
    	Complejo resultado;

	cout << "--------------------------------\n";
	cout << "-     COMPROBACION DE SUMA     -\n";
	cout << "--------------------------------\n\n";
	
	resultado = operandoA + operandoB;
	
	operandoA.print();
	cout << " + ";
	operandoB.print();
	cout << " = ";
	resultado.print();
	cout << endl << endl;
	/*Para la ejecucion del programa hasta que el usuario pulsa una tecla.*/
	getchar();
	getchar();
}

/**
 * Multiplica dos numeros complejos y muestra el resultado por pantalla.
 * 
 * @pre Dos numeros complejos validos.
 * @post Numero complejo vulido.     
 * @return void.
 */
void comprobarMulti(Complejo operandoA, Complejo operandoB)
{
    	Complejo resultado;

	cout << "---------------------------------------------\n";
	cout << "-     COMPROBACION DE LA MULTIPLICACION     -\n";
	cout << "---------------------------------------------\n\n";

	resultado = operandoA * operandoB;

	operandoA.print();
	cout << " * ";
	operandoB.print();
	cout << " = ";
	resultado.print();
	cout << endl << endl;
	/*Para la ejecucion del programa hasta que el usuario pulsa una tecla.*/
	getchar();
	getchar();
}




int main()
{
	/**
	 * Opcion.
	 * Almacena la opcion elegida por el usuario en el menu del programa.
	 */
	int opcion;
	
	/**
	 * Objetos de la clase "Complejo" sobre los que se realizan las operaciones.
	 */
	Complejo complejoA, complejoB;



    	do
	{
		system("clear");
		cout << "-------------------------------------------------------\n";
		cout << "-                    TEST DE COMPLEJOS                -\n";
		cout << "-------------------------------------------------------\n";
		cout << "- 1) Comprobar la igualdad entre dos complejos.       -\n";
		cout << "- 2) Sumar dos complejos.                             -\n";
		cout << "- 3) Multiplicar dos complejos.                       -\n";
		cout << "- 4) Salir del programa.                              -\n";
		cout << "-------------------------------------------------------\n\n";
		

		cout << " Introduce una opcion: ";
		cin >> opcion;		
		system("clear");
		
		//Evita tener que introducir los complejos si se quiere salir del programa.
		if (opcion !=4)
		{
			cout << "Primer complejo\n";
			complejoA = introducirComplejo();
			cout << "Segundo complejo\n";
			complejoB = introducirComplejo();
		}
		
		switch(opcion)
		{
			case 1:
				comprobarIgualdad(complejoA, complejoB);
				break;
			case 2:
			    comprobarSuma(complejoA, complejoB);
				break;
			case 3:
			    comprobarMulti(complejoA, complejoB);
				break;
			case 4:
				break;
			default:
				cout << "Opcion incorrecta.\n\n";
		}
	
	}
	while(opcion !=4);	
		
	
	return 0;
}


