/*****************************
 * Practica 3 MP
 * Curso 2008-2009
 *
 * Vicente Lujan Mansilla
 * Lorena Margareto Bisquert
 *****************************/

#ifndef _BUSQUEDA_H
#define _BUSQUEDA_H

#include <vector>
#include <iostream>
#include <stdlib.h>
#include "DataGenerator.h"

using namespace std;

class Busqueda 
{
      public:
         /**
		 * Busca de forma binaria iterativa en un vector ordenado sin repeticiones.
		 *
		 * @param ini Inicio del intervalo.
		 * @param end Fin del intervalo.
		 * @param inc Incremento.
		 * @param outComp Fichero que almacena las comparaciones.
		 */
 		void testBB_I(int ini, int end, int inc, ostream& outComp);

		/**
		 * Busca de forma binaria recursiva en un vector ordenado sin repeticiones.
		 *
		 * @param ini Inicio del intervalo.
		 * @param end Fin del intervalo.
		 * @param inc Incremento.
		 * @param outComp Fichero que almacena las comparaciones.
		 */
 		void testBB_R(int ini, int end, int inc, ostream& outComp);
 		
 		/**
		 * Busca de forma ternaria iterativa en un vector ordenado sin repeticiones.
		 *
		 * @param ini Inicio del intervalo.
		 * @param end Fin del intervalo.
		 * @param inc Incremento.
		 * @param outComp Fichero que almacena las comparaciones.
		 */
 		void testBT(int ini, int end, int inc, ostream& outComp);
 		
 		
 		
 		/**
		 * Busca de forma binaria iterativa en un vector ordenado sin repeticiones.
		 *
		 * @param ini Inicio del intervalo.
		 * @param end Fin del intervalo.
		 * @param inc Incremento.
		 * @param outComp Fichero que almacena las comparaciones.
		 */
 		void testBB_I_real(int ini, int end, int inc, ostream& outComp);

		/**
		 * Busca de forma binaria recursiva en un vector ordenado sin repeticiones.
		 *
		 * @param ini Inicio del intervalo.
		 * @param end Fin del intervalo.
		 * @param inc Incremento.
		 * @param outComp Fichero que almacena las comparaciones.
		 */
 		void testBB_R_real(int ini, int end, int inc, ostream& outComp);
 		
 		/**
		 * Busca de forma ternaria iterativa en un vector ordenado sin repeticiones.
		 *
		 * @param ini Inicio del intervalo.
		 * @param end Fin del intervalo.
		 * @param inc Incremento.
		 * @param outComp Fichero que almacena las comparaciones.
		 */
 		void testBT_real(int ini, int end, int inc, ostream& outComp);
             
         	/**
          	* Realiza la busqueda binaria iterativa en un vector.
          	*
          	* @param v Vector de numeros enteros.
          	* @param x Elemento a encontrar.
          	*
          	* @return Exito en la busqueda.
          	*/
	      	bool BusquedaBinaria_I(vector<VElement> &v, VElement x);
	      	/**
          	* Realiza la busqueda binaria recursiva en un vector.
          	*
          	* @param v Vector de numeros enteros.
          	* @param izq Posicion izquierda del vector.
          	* @param der Posicion derecha del vector.
          	* @param x Elemento a encontrar.
          	*
          	* @return Exito en la busqueda.
          	*/
	      bool BusquedaBinaria_R(vector<VElement> &v, int izq, int der, VElement x);

          	/**
          	* Realiza la busqueda ternaria iterativa en un vector.
          	*
          	* @param v Vector de numeros enteros.
          	* @param x Elemento a encontrar.
          	*
          	* @return Exito en la busqueda.
          	*/
	      bool BusquedaTernaria_I(vector<VElement> &v, VElement x);
};

#endif
