/**
* Practicas de Metodologia de la Programacion.
 * Curso 2008-2009
 * Departament d'Informatica.
 * Universitat de Valencia.
 */


#include "VElement.h"


/**
 * Clase de elementos de vector que mantiene contador estático de intercambios.
 *
 */
int VElement::nAssign = 0;
int VElement::nComparison = 0;

VElement::VElement()
{
    value = 0;
}

VElement::VElement(int v)
{
    value = v;
}

void VElement::set(int v)
{
    value = v;
    nAssign++;
}

int VElement::get() const
{
    return value;
}



bool VElement::operator >(const VElement &vE) const
{
    nComparison ++;
    return (get() > vE.get());
}

bool VElement::operator >(int e) const
{
    nComparison ++;
    return (get() > e);
}

bool VElement::operator <(const VElement &vE) const
{
    nComparison ++;
    return (get() < vE.get());
}

bool VElement::operator <(int e) const
{
    nComparison ++;
    return (get() < e);
}

bool VElement::operator >=(const VElement &vE) const
{
    nComparison ++;
    return (get() >= vE.get());
}
bool VElement::operator >=(int e) const
{
    nComparison ++;
    return (get() >= e);
}

bool VElement::operator <=(const VElement &vE) const
{
    nComparison ++;
    return (get() <= vE.get());
}
bool VElement::operator <=(int e) const
{
    nComparison ++;
    return (get() <= e);
}

bool VElement::operator ==(const VElement &vE) const
{
    nComparison ++;
    return (get() == vE.get());
}

bool VElement::operator ==(int e) const
{
    nComparison ++;
    return (get() == e);
}

VElement & VElement::operator =(int e)
{
    value = e;
    return *this;
}

VElement & VElement::operator =(const VElement &vE)
{
    value = vE.value;
    return *this;
}


