/*****************************
 * Practica 3 MP
 * Curso 2008-2009
 *
 * Vicente Lujan Mansilla
 * Lorena Margareto Bisquert
 *****************************/

#ifndef _DATA_GENERATOR_H
#define _DATA_GENERATOR_H

#include <iostream>
#include <vector>
#include <algorithm>
#include "VElement.h"

using namespace std;

/**
 * Libreria para la generacion aleatoria de vectores.
 *
 */
class DataGenerator {

    public:
    
    /**
	* Crea una instancia de la clase generadora de vectores.
	* <BR>
	* En la creacion de la instancia se inicializa la semilla aleatoria.
	*/
    DataGenerator();
        
    /**
	* Rellena un vector de numeros enteros con posibilidad de repeticion.
	*
	* @param v Vector de enteros a rellenar.
	* @param veces Numero de repeticiones.
	*/
    void vectorOrdRep(vector<VElement> &v, float veces);

	 /**
	* Rellena un vector de numeros enteros con posibilidad de repeticion y elementos intercambiados.
	*
	* @param v Vector de enteros a rellenar.
	* @param veces Numero de repeticiones.
	* @param porcentaje Porcentaje que indica el numero de intercambios.
	*/
	void vectorConRepeticion(vector<VElement> &v, float veces, float porcentaje);
        
    /**
	* Rellena un vector de numeros enteros sin repeticion de elementos.
	*
	* @param v Vector de enteros a rellenar.
	*/
    void vectorOrd(vector<VElement> &v);

    /**
	* Rellena un vector de numeros enteros sin repeticion de elementos y lo invierte.
	*
	* @param v Vector de enteros a rellenar.
	*/
    void vectorOrdInv(vector<VElement> &v);

    /**
	* Genera un numero natural aleatorio entre 0 y un maximo (incluido).
	* 
	* @param max Limite maximo del numero a utilizar.
	*
	* @return Numero natural aleatorio.
	*/        
    int numAleat(int max);


    /**
	 * Mezcla los elementos de un vector, realizando un porcentaje 
	 * de intercambios con respecto a su tama�o.<BR>
	 *
	 * Ejemplo de aplicacion:
	 * <CODE>
	 *     interchangeElements({1,2,3,4,5,6,7,8,9,10},40)<BR><BR>
	 *     Realiza v.size()*40/100 = 4 intercambios de elementos, lo 
	 *     que significa que por ejemplo selecciona el 1 y lo cambia
	 *     por el 5 (que tambien selecciona aleatoriamente), y hace
	 *     lo mismo con el 4 y el 7.
	 * </CODE>
	 * 
	 * @param v Vector a mezclar.
	 * @param porcentaje Porcentaje que indica el numero de intercambios
	 *                   a realizar en la mezcla del vector.
	 */
    void intercambiarElem(vector<VElement> &v, float porcentaje);

	/**
	* Comprueba que el vector pasado como parámetro está ordenado y 
	 * devuelve true si es así y false en caso contrario.
	 * @param v Vector a comprobar.
	 * @return true si ordenado.
	*/
    bool ordenado(const vector<VElement> & v);	

    /**
     * Imprime un vector por la salida estandar.
     * @param v Vector a imprimir.
     */
    void printVector(const vector<VElement> & v);

};


#endif

