/*****************************
 * Practica 4 MP
 * Curso 2008-2009
 *
 * Vicente Lujan Mansilla
 * Lorena Margareto Bisquert
 *****************************/
 
#ifndef _ORDENACION_H
#define _ORDENACION_H

#include <iostream>
#include <fstream>
#include <vector>
#include "DataGenerator.h"

using namespace std;

typedef vector<int> Vector;

/**
 * Libreria para la ordenacion de vectores mediante distintos metodos.
 */
class Ordenacion
{	
    public:
       /**
	* Ordena los datos de un vector mediante el metodo asignado.
	*
	* @param ini Inicio del intervalo.
	* @param end Fin del intervalo.
	* @param inc Incremento.
	* @param salida Fichero que almacena las comparaciones+intercambios.
	* @param porcentaje Porcentaje de elementos no ordenados en el vector.
	*/
        void testInsercion1(int ini, int end, int inc, ostream& salida, float porcentaje);
	/**
	* Ordena los datos de un vector mediante el metodo asignado.
	*
	* @param ini Inicio del intervalo.
	* @param end Fin del intervalo.
	* @param inc Incremento.
	* @param salida Fichero que almacena las comparaciones+intercambios.
	* @param porcentaje Porcentaje de elementos no ordenados en el vector.
	*/
        void testInsercion2(int ini, int end, int inc, ostream& salida, float porcentaje);

/**
	* Ordena los datos de un vector mediante el metodo asignado.
	*
	* @param ini Inicio del intervalo.
	* @param end Fin del intervalo.
	* @param inc Incremento.
	* @param salida Fichero que almacena las comparaciones+intercambios.
	* @param porcentaje Porcentaje de elementos no ordenados en el vector.
	*/
        void testSeleccion1(int ini, int end, int inc, ostream& salida, float porcentaje);
	/**
	* Ordena los datos de un vector mediante el metodo asignado.
	*
	* @param ini Inicio del intervalo.
	* @param end Fin del intervalo.
	* @param inc Incremento.
	* @param salida Fichero que almacena las comparaciones+intercambios.
	* @param porcentaje Porcentaje de elementos no ordenados en el vector.
	*/
        void testSeleccion2(int ini, int end, int inc, ostream& salida, float porcentaje);


	/**
	* Ordena los datos de un vector mediante el metodo asignado.
	*
	* @param ini Inicio del intervalo.
	* @param end Fin del intervalo.
	* @param inc Incremento.
	* @param salida Fichero que almacena las comparaciones+intercambios.
	* @param porcentaje Porcentaje de elementos no ordenados en el vector.
	*/
        void testBurbuja1(int ini, int end, int inc, ostream& salida, float porcentaje);
	/**
	* Ordena los datos de un vector mediante el metodo asignado.
	*
	* @param ini Inicio del intervalo.
	* @param end Fin del intervalo.
	* @param inc Incremento.
	* @param salida Fichero que almacena las comparaciones+intercambios.
	* @param porcentaje Porcentaje de elementos no ordenados en el vector.
	*/
        void testBurbuja2(int ini, int end, int inc, ostream& salida, float porcentaje);


	/**
	*
	* @param ini Inicio del intervalo.
	* @param end Fin del intervalo.
	* @param inc Incremento.
	* @param salida1 Fichero que almacena las comparaciones.
	* @param salida2 Fichero que almacena las comparaciones.
	* @param porcentaje Porcentaje de elementos no ordenados en el vector.
	*/
	void testBurbujaEstudio1(int ini, int end, int inc, ostream& salida1, ostream& salida2,  float porcentaje);

	/**
	*
	* @param ini Inicio del intervalo.
	* @param end Fin del intervalo.
	* @param inc Incremento.
	* @param salida1 Fichero que almacena las comparaciones.
	* @param salida2 Fichero que almacena las comparaciones.
	* @param veces Numero de repeticiones.
	* @param porcentaje Porcentaje de elementos no ordenados en el vector.
	*/
	void testBurbujaEstudio2(int ini, int end, int inc, ostream& salida1, ostream& salida2,  float veces, float porcentaje);
		
	/**
	* Ordena mediante el algoritmo de Insercion.
	*
	* @param v Vector a ordenar.
	*/	
        void Insercion(vector<VElement> &v);
            
	/**
	* Ordena mediante el algoritmo de Seleccion.
	*
	* @param v Vector a ordenar.
	*/
	void Seleccion(vector<VElement> &v);

        /**
        * Ordena mediante el algoritmo de Burbuja.
        *    
        * @param v Vector a ordenar.
        */	
        void Burbuja(vector<VElement> &v);
};

#endif
