/*****************************
 * Practica 7 MP
 * Curso 2008-2009
 *
 * Vicente Lujan Mansilla
 * Lorena Margareto Bisquert
 *****************************/

#ifndef _GRAPH_H
#define _GRAPH_H

#include <vector>

using namespace std;

/**
 * Grafo
 *
 */
class Graph 
{
	public:

		vector< vector<int> > matriz;
		unsigned tam;
		unsigned accesos;
		
		/** 
		*  Crea una instancia del grafo de tamaño n con todos los valores a 0 
		*  @param n Tamaño del grafo . 
		**/ 
		Graph(unsigned n); 
 
		/** 
		* Operador para asignar y obtener los elementos del grafo . 
		*  @param f Coordenada x de la matriz . 
		*  @param c Coordenada y de la matriz . 
		*  @return Elemento del grafo . 
		**/ 
		inline int & operator()(unsigned f, unsigned c)
		{
			accesos++;
			assert(f>=0 && c>=0);
			return matriz[(f>=tam) ? tam-1 : f][(c>=tam) ? tam-1 : c];					
		}
 
		/** 
		*  Obtiene el tamaño del grafo . 
		*  @return Tamaño del grafo . 
		**/ 
		unsigned size(); 
 
		/** 
		*  Muestra la matriz del grafo por pantalla . 
		**/ 
		void print(); 
 
		/** 
		* Obtiene un número de nodo aleatoriamente 
		*  
		*  @return Número de nodo del grafo . 
		**/ 
		unsigned nodoAleat(); 
		
		/** 
		* Genera un grafo dirigido aleatorio cuyos arcos tienen pesos  
		* enteros entre min y max incluidos.  
		* Los arcos de un nodo a si mismo tienen valor 0. 
		*  
		* @param min Valor minimo para el peso de un arco 
		* @param max Valor maximo para el peso de un arco 
		**/ 
		void grafoAleat(int min, int max); 
 
		/** 
		* Genera un grafo no dirigido aleatorio cuyos arcos tienen pesos  
		* enteros entre min y max incluidos.  
		* Los arcos de un nodo a si mismo tienen valor 0. 
		*  
		* @param min Valor minimo para el peso de un arco 
		* @param max Valor maximo para el peso de un arco 
		**/ 
		void grafoAleatND(int min, int max); 
 
		/** 
		* Devuelve el número de accesos a elementos del grafo . 
		*  @return accesos al grafo . 
		**/ 
		unsigned getAccesos() ; 

};
#endif

