/*****************************
 * Practica 8 MP
 * Curso 2008-2009
 *
 * Vicente Lujan Mansilla
 * Lorena Margareto Bisquert
 *****************************/

#ifndef _GRAPH_H
#define _GRAPH_H

#include <vector>

using namespace std;

/**
 * Grafo
 *
 */
class Graph 
{
      private:
              vector< vector<int> > matriz;
	      unsigned tam;
	      unsigned accesos;

      public:
    		/** 
    		*  Crea una instancia del grafo de tamaño n con todos los valores a 0 
    		*  @param n Tamaño del grafo . 
    		**/ 
    		Graph(unsigned n); 
     
    		/** 
    		* Operador para asignar y obtener los elementos del grafo . 
    		*  @param f Coordenada x de la matriz . 
    		*  @param c Coordenada y de la matriz . 
    		*  @return Elemento del grafo . 
    		**/ 
    		inline int & operator()(unsigned f, unsigned c)
    		{
    			accesos++;
    			assert(f>=0 && c>=0);
    			assert(f < matriz.size() && c < matriz.size());	
                
                return(matriz[f][c]);				
    		}
     
    		/** 
    		*  Obtiene el tamaño del grafo . 
    		*  @return Tamaño del grafo . 
    		**/ 
    		unsigned size(); 
 
    		/** 
    		*  Muestra la matriz del grafo por pantalla . 
    		**/ 
    		void print(); 
     
    		/** 
    		* Obtiene un número de nodo aleatoriamente 
    		*  
    		*  @return Número de nodo del grafo . 
    		**/ 
    		unsigned numAleat(); 
    		
    		/** 
    		* Genera un grafo dirigido aleatorio cuyos arcos tienen pesos  
    		* enteros entre min y max incluidos.  
    		* Los arcos de un nodo a si mismo tienen valor 0. 
    		*  
    		* @param min Valor minimo para el peso de un arco 
    		* @param max Valor maximo para el peso de un arco 
    		**/ 
    		void grafoAleat(int min, int max); 
     
    		/** 
    		* Genera un grafo no dirigido aleatorio cuyos arcos tienen pesos  
    		* enteros entre min y max incluidos.  
    		* Los arcos de un nodo a si mismo tienen valor 0. 
    		*  
    		* @param min Valor minimo para el peso de un arco 
    		* @param max Valor maximo para el peso de un arco 
    		**/ 
    		void grafoAleatND(int min, int max); 
     
    		/** 
    		* Devuelve el número de accesos a elementos del grafo . 
    		*  @return accesos al grafo . 
    		**/ 
    		unsigned getAccesos() ; 
    
    
    		/** 
    		* Inicializa el número de accesos del/al grafo . 
    		**/ 
    		void initAccesos(){
    			accesos = 0;
    		} 
    
    		/**
    		* Conecta los nodos n1 y n2 asignando pesos aleatorios
    		* al camino que une a ambos y que pasa por todos los nodos
    		* 
    		* @param n1 Nodo 1
    		* @param n2 Nodo 2
    		* @param grado_conect Conectividad
    		**/
    		void conectar(int n1, int n2, float grado_conect);

};
#endif

